unit ImageBuf01;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, Buttons,
  CraphCommomTools;

type TObImgItm = class(TObject)
     fBitMap   : TBitMap;   // BitMap 
     fScale    : double;    //   
     fWork     : double;    //  
     constructor Create;
     procedure Free();
end;

type
  TFormImgBuf = class(TForm)
    Panel1: TPanel;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    Panel2: TPanel;
    TrackBar1: TTrackBar;
    Lb10: TLabel;
    Lb100: TLabel;
    Lb200: TLabel;
    STxtScale: TStaticText;
    SpButScale: TSpeedButton;
    LstBoxFragment: TListBox;
    SpButDelete: TSpeedButton;
    SpButEdTxt: TSpeedButton;
    SpeedButton2: TSpeedButton;
    EdItem: TEdit;
    StTxtH: TStaticText;
    StTxtW: TStaticText;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    StTxtFragScale: TStaticText;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure TrackBar1Change(Sender: TObject);
    procedure LstBoxFragmentClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpButScaleClick(Sender: TObject);
    procedure SpButEdTxtClick(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpButDeleteClick(Sender: TObject);
  private
    { Private declarations }
    procedure ShowObImgItmParm(ObImgItm : TObImgItm);
  public
    { Public declarations }
    procedure AddImgItem (var ImgItm : TImgItm);

    procedure GetImgItem (var ImgItm : TImgItm);

  end;

var
  FormImgBuf: TFormImgBuf;



implementation

{$R *.dfm}
uses ImgScale01;

//      Images
var ImageScale     : TImageScale;

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
constructor TObImgItm.Create;
begin
  inherited Create;
  fBitMap := TBitMap.Create;
  fBitMap.PixelFormat := pf24bit;
end;

procedure TObImgItm.Free();
begin
   if Assigned(fBitMap) then fBitMap.Free;
   inherited Free;
end;
// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
//      
procedure TFormImgBuf.ShowObImgItmParm(ObImgItm : TObImgItm);
var Ind      : integer;
begin
  if LstBoxFragment.ItemIndex >=0
  then begin
     Ind := LstBoxFragment.ItemIndex;
     ObImgItm := TObImgItm(LstBoxFragment.Items.Objects[Ind]);
     //  ImgItm.BitMap  Image1
     Image1.Picture.Bitmap.Height := ObImgItm.fBitMap.Height;
     Image1.Picture.Bitmap.Width  := ObImgItm.fBitMap.Width;
     Image1.Picture.Bitmap.Assign(ObImgItm.fBitMap);
     //   
     EdItem.Text := LstBoxFragment.Items[Ind];
     StTxtH.Caption := IntToStr(ObImgItm.fBitMap.Height);
     StTxtW.Caption := IntToStr(ObImgItm.fBitMap.Width);
     StTxtFragScale.Caption := IntToStr(Round(ObImgItm.fScale * 100));
  end;
end;
// -----------------------------------------------------------------------
//     
procedure TFormImgBuf.AddImgItem (var ImgItm : TImgItm);
var ObImgItm : TObImgItm;
    Ind      : integer;
begin
   if not Assigned(ImgItm.BitMap) then Exit;
   //   BitMap     ImgItm.BitMap
   ObImgItm := TObImgItm.Create;
   ObImgItm.fBitMap.Height := ImgItm.BitMap.Height;
   ObImgItm.fBitMap.Width  := ImgItm.BitMap.Width;
   ObImgItm.fBitMap.Assign(ImgItm.BitMap);
   //    100%
   ObImgItm.fScale := 1;
   ObImgItm.fWork  := ObImgItm.fScale;
   //   ObImgItm  LstBoxFragment
   Ind := LstBoxFragment.Items.AddObject('Item', ObImgItm);
   //     
   LstBoxFragment.ItemIndex := Ind;
   //    
   ShowObImgItmParm(ObImgItm);
end;
// -----------------------------------------------------------------------
//    
procedure TFormImgBuf.LstBoxFragmentClick(Sender: TObject);
var ObImgItm : TObImgItm;
    Ind      : integer;
begin
   if LstBoxFragment.ItemIndex >=0
   then begin
     Ind := LstBoxFragment.ItemIndex;
     ObImgItm := TObImgItm(LstBoxFragment.Items.Objects[Ind]);
     ShowObImgItmParm(ObImgItm);
   end;
end;

// -----------------------------------------------------------------------
procedure TFormImgBuf.TrackBar1Change(Sender: TObject);
begin
   STxtScale.Caption := IntToStr(TrackBar1.Position);
end;
// -----------------------------------------------------------------------
//    
procedure TFormImgBuf.SpButScaleClick(Sender: TObject);
var ObImgItm : TObImgItm;
    Ind      : integer;
begin
  if LstBoxFragment.ItemIndex >=0
  then begin
     Ind := LstBoxFragment.ItemIndex;
     ObImgItm := TObImgItm(LstBoxFragment.Items.Objects[Ind]);
     ObImgItm.fWork := ObImgItm.fScale;
     if Assigned(ImageScale)
     then begin
        //   
        ImageScale.Zoom := TrackBar1.Position / 100;
        //  
        ImageScale.RunScaleHW;
        //   
        ObImgItm.fWork := ObImgItm.fWork * (TrackBar1.Position / 100);
     end;
  end;
end;

// -----------------------------------------------------------------------
//    
procedure TFormImgBuf.SpButEdTxtClick(Sender: TObject);
var Ind      : integer;
begin
   if LstBoxFragment.ItemIndex >=0
   then begin
     Ind := LstBoxFragment.ItemIndex;
     LstBoxFragment.Items[Ind] := EdItem.Text;
   end;
end;

// -----------------------------------------------------------------------
//     
procedure TFormImgBuf.SpeedButton2Click(Sender: TObject);
var ObImgItm : TObImgItm;
    Ind      : integer;
begin
  if LstBoxFragment.ItemIndex >=0
  then begin
     Ind := LstBoxFragment.ItemIndex;
     ObImgItm := TObImgItm(LstBoxFragment.Items.Objects[Ind]);
     //  
     ObImgItm.fBitMap.Height := Image1.Picture.BitMap.Height;
     ObImgItm.fBitMap.Width  := Image1.Picture.BitMap.Width;
     ObImgItm.fBitMap.Assign(Image1.Picture.BitMap);
     //   
     ObImgItm.fScale := ObImgItm.fWork;
     //    ObImgItm
     ShowObImgItmParm(ObImgItm);
  end;
end;
// -----------------------------------------------------------------------
//   
procedure TFormImgBuf.SpButDeleteClick(Sender: TObject);
var ObImgItm : TObImgItm;
    Ind      : integer;
begin
  if LstBoxFragment.ItemIndex >=0
  then begin
     Ind := LstBoxFragment.ItemIndex;
     ObImgItm := TObImgItm(LstBoxFragment.Items.Objects[Ind]);
     //   
     if Assigned(ObImgItm) then ObImgItm.Free;
     //    
     Image1.Picture.BitMap.Height := 1;
     Image1.Picture.BitMap.Width  := 1;
     //   
     LstBoxFragment.Items.Delete(Ind);
     if LstBoxFragment.Count > 0
     then begin
        //    
        LstBoxFragment.ItemIndex := LstBoxFragment.Count - 1;
        //    
        LstBoxFragmentClick(Self);
     end
     else begin
        //    
        EdItem.Text := '';
        StTxtH.Caption := '';
        StTxtW.Caption := '';
        StTxtFragScale.Caption := '';
     end;
  end;
end;

//      
procedure TFormImgBuf.GetImgItem (var ImgItm : TImgItm);
var ObImgItm : TObImgItm;
    Ind      : integer;
begin
  if LstBoxFragment.ItemIndex >=0
  then begin
     Ind := LstBoxFragment.ItemIndex;
     ObImgItm := TObImgItm(LstBoxFragment.Items.Objects[Ind]);
     //  
     ImgItm.BitMap.Height := ObImgItm.fBitMap.Height;
     ImgItm.BitMap.Width  := ObImgItm.fBitMap.Width;
     ImgItm.BitMap.Assign(ObImgItm.fBitMap);
  end
  else begin
     MessageDlg('     ',
                 mtConfirmation, [mbOk], 0)
  end;
end;

// =======================================================================
//    - 
// =======================================================================
procedure TFormImgBuf.FormCreate(Sender: TObject);
begin
   ImageScale := nil;
   try
     //      Images
     ImageScale := TImageScale.Create;
     ImageScale.Proportional := True;
     ImageScale.ImageSrc := Image1;
     ImageScale.ImageTrg := Image1;
     ImageScale.Zoom := 1;
     TrackBar1.Position := 100;
     STxtScale.Caption  := IntToStr(TrackBar1.Position);
   except
   end;
end;

procedure TFormImgBuf.FormDestroy(Sender: TObject);
begin
   if Assigned(ImageScale)
   then ImageScale.Free;
end;




end.
